
<?php
// config.php - اتصال بقاعدة البيانات
$host = 'localhost';
$user = 'root';
$pass = '';
$db = 'forlife_institute1';
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
// إنشاء الجداول إذا لم تكن موجودة
$createTables = [
    "CREATE TABLE IF NOT EXISTS diplomas (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(100),
        description TEXT,
        icon VARCHAR(255)
    )",
    "CREATE TABLE IF NOT EXISTS courses (
        id INT AUTO_INCREMENT PRIMARY KEY,
        diploma_id INT,
        name VARCHAR(100),
        price DECIMAL(10,2),
        FOREIGN KEY (diploma_id) REFERENCES diplomas(id)
    )",
    "CREATE TABLE IF NOT EXISTS books (
        id INT AUTO_INCREMENT PRIMARY KEY,
        title VARCHAR(200),
        author VARCHAR(100),
        image VARCHAR(255),
        description TEXT,
        category VARCHAR(50),
        rating DECIMAL(2,1)
    )",
    "CREATE TABLE IF NOT EXISTS messages (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(100),
        email VARCHAR(100),
        message TEXT,
        sent_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )"
];
foreach ($createTables as $sql) {
    $conn->query($sql);
}
// إدخال بيانات تجريبية إذا كانت الجداول فارغة
$diplomas = $conn->query("SELECT COUNT(*) as count FROM diplomas")->fetch_assoc()['count'];
if ($diplomas == 0) {
    $conn->query("INSERT INTO diplomas (name, description, icon) VALUES 
        ('دبلوم اللغة الإنجليزية', 'دبلوم شامل في اللغة الإنجليزية من المستوى المبتدئ حتى المتقدم', 'english.png'),
        ('دبلوم الحاسوب', 'دورات متقدمة في استخدام الحاسوب وبرامج الأوفيس', 'computer.png'),
        ('دبلوم التمريض', 'دورات متخصصة في أساسيات التمريض والعناية الصحية', 'nursing.png'),
        ('دبلوم الجرافيك', 'تصميم جرافيك احترافي باستخدام أدوات حديثة', 'graphic.png'),
        ('دبلوم البرمجة', 'برمجة تطبيقات ويب وجوال باستخدام أحدث التقنيات', 'coding.png'),
        ('دبلوم الإسعافات الأولية', 'تدريب عملي على الإسعافات الأولية والطوارئ', 'firstaid.png')");
    $conn->query("INSERT INTO courses (diploma_id, name, price) VALUES 
        (1, 'Code 1', 150.00),
        (1, 'Code 2', 150.00),
        (1, 'Code 3', 150.00),
        (1, 'Code 4', 150.00),
        (1, 'Starter A', 200.00),
        (1, 'Starter B', 200.00),
        (1, 'Level 1A', 250.00),
        (1, 'Level 1B', 250.00),
        (1, 'Level 2A', 300.00),
        (1, 'Level 2B', 300.00),
        (1, 'Level 3A', 350.00),
        (1, 'Level 3B', 350.00),
        (1, 'Level 4A', 400.00),
        (1, 'Level 4B', 400.00),
        (2, 'Windows', 100.00),
        (2, 'Word', 100.00),
        (2, 'Excel', 120.00),
        (2, 'PowerPoint', 100.00),
        (2, 'Print', 80.00),
        (2, 'Internet', 90.00),
        (2, 'Computer Security', 150.00),
        (3, 'علم الأدوية', 200.00),
        (3, 'أساسيات التمريض', 250.00),
        (3, 'المصطلحات الطبية', 150.00),
        (3, 'الطفيليات', 180.00),
        (3, 'الصحة العامة', 200.00),
        (4, 'تصميم الشعارات', 300.00),
        (4, 'التصوير الفوتوغرافي', 350.00),
        (4, 'تصميم الويب', 400.00),
        (4, 'الرسوم المتحركة', 350.00),
        (5, 'برمجة الويب', 500.00),
        (5, 'برمجة الجوال', 550.00),
        (5, 'قواعد البيانات', 400.00),
        (5, 'الذكاء الاصطناعي', 600.00),
        (6, 'الإسعافات الأولية', 250.00),
        (6, 'الإنعاش القلبي الرئوي', 200.00),
        (6, 'معالجة الجروح', 220.00)");
    $conn->query("INSERT INTO books (title, author, image, description, category, rating) VALUES 
        ('الإنجليزية للمبتدئين', 'د. أحمد محمد', 'book1.jpg', 'دورة شاملة للمرحلة المبتدئة في اللغة الإنجليزية', 'لغات', 4.5),
        ('الحاسوب الأساسي', 'م. فاطمة علي', 'book2.jpg', 'مبادئ استخدام الحاسوب وأنظمة التشغيل', 'تقنية', 4.2),
        ('التمريض العملي', 'د. سارة أحمد', 'book3.jpg', 'تطبيقات عملية في التمريض السريري', 'طب', 4.8),
        ('الجرافيك الحديث', 'م. خالد عمر', 'book4.jpg', 'أحدث تقنيات التصميم الجرافيكي', 'فن', 4.6),
        ('البرمجة بلغة بايثون', 'د. محمد حسن', 'book5.jpg', 'مقدمة في البرمجة بلغة بايثون للمبتدئين', 'تقنية', 4.7),
        ('الإسعافات الأولية', 'د. علي عبد الله', 'book6.jpg', 'دليل الإسعافات الأولية في الحالات الطارئة', 'طب', 4.3),
        ('اللغة الإنجليزية المتوسطة', 'د. نادية محمود', 'book7.jpg', 'للمستوى المتوسط في تعلم اللغة الإنجليزية', 'لغات', 4.4),
        ('تطوير الويب', 'م. رامي سعيد', 'book8.jpg', 'بناء المواقع الإلكترونية باستخدام HTML وCSS', 'تقنية', 4.9),
        ('تصميم الشعارات', 'م. هند محمد', 'book9.jpg', 'فن تصميم الشعارات الاحترافي', 'فن', 4.1),
        ('الطب الطارئ', 'د. عماد أحمد', 'book10.jpg', 'التعامل مع الحالات الطارئة في الطب', 'طب', 4.6),
        ('الذكاء الاصطناعي', 'د. ياسر علي', 'book11.jpg', 'مقدمة في الذكاء الاصطناعي وتطبيقاته', 'تقنية', 4.8),
        ('التصوير الفوتوغرافي', 'م. سمر خالد', 'book12.jpg', 'أساسيات التصوير الفوتوغرافي الاحترافي', 'فن', 4.2),
        ('الطب النفسي', 'د. محمد عبد الكريم', 'book13.jpg', 'مبادئ الطب النفسي والعلاج النفسي', 'طب', 4.5),
        ('التسويق الرقمي', 'د. رنا محمد', 'book14.jpg', 'التسويق عبر الإنترنت ووسائل التواصل الاجتماعي', 'إدارة', 4.3),
        ('إدارة المشاريع', 'د. خالد أحمد', 'book15.jpg', 'أساسيات إدارة المشاريع وتقنيات التخطيط', 'إدارة', 4.4),
        ('الاقتصاد الرقمي', 'د. فاطمة حسن', 'book16.jpg', 'التحول الرقمي في الاقتصاد والتجارة', 'اقتصاد', 4.1),
        ('الروبوتات', 'د. أحمد سالم', 'book17.jpg', 'مقدمة في عالم الروبوتات والأنظمة الذكية', 'تقنية', 4.7),
        ('الطب البيطري', 'د. سعيد محمد', 'book18.jpg', 'العناية بالحيوانات والطب البيطري', 'طب', 4.5),
        ('الصيدلة', 'د. نورا أحمد', 'book19.jpg', 'أساسيات علم الأدوية والتفاعلات الدوائية', 'طب', 4.6),
        ('الطب البشري', 'د. محمد علي', 'book20.jpg', 'علم التشريح والفيزيولوجيا البشرية', 'طب', 4.8),
        ('الطب البيطري المتقدم', 'د. خالد سالم', 'book21.jpg', 'تطبيقات متقدمة في الطب البيطري', 'طب', 4.4),
        ('الطب النفسي للأطفال', 'د. سمر أحمد', 'book22.jpg', 'الطب النفسي للأطفال والمراهقين', 'طب', 4.3),
        ('الطب الجراحي', 'د. أحمد محمد', 'book23.jpg', 'أساسيات الجراحة والتقنيات الجراحية', 'طب', 4.7),
        ('الطب الوقائي', 'د. فاطمة خالد', 'book24.jpg', 'الوقاية من الأمراض والطب الوقائي', 'طب', 4.5),
        ('الطب البديل', 'د. علي سعيد', 'book25.jpg', 'الطب البديل والطاقة والعلاجات البديلة', 'طب', 4.2)");
}
// عند إرسال رسالة
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['send_message'])) {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $message = $_POST['message'];
    $stmt = $conn->prepare("INSERT INTO messages (name, email, message) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $name, $email, $message);
    $stmt->execute();
    // إرسال إلى البريد
    mail("forlife.institute.radaa@gmail.com", "رسالة جديدة من موقع معهد فورلايف", "الاسم: $name
البريد: $email
الرسالة: $message");
    echo "<script>alert('تم إرسال رسالتك بنجاح!');</script>";
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>معهد فورلايف - التعليم المستقبلي</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700&display=swap');
        :root {
            --black: #000000;
            --white: #FFFFFF;
            --dark-blue: #00008B; /* أزرق غامق جداً */
            --red: #DC143C; /* أحمر داكن */
            --light-gray: #F0F0F0;
            --dark-gray: #333333;
            --silver: #C0C0C0;
            --light-blue: #1E90FF; /* أزرق فاتح */
            --gold: #FFD700; /* ذهبي */
            --purple: #800080; /* بنفسجي */
            --green: #228B22; /* أخضر داكن */
            --orange: #FF8C00; /* برتقالي داكن */
            --cyan: #00FFFF; /* سماوي */
            --magenta: #FF00FF; /* أرجواني */
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Cairo', sans-serif;
        }
        body {
            background: var(--white);
            color: var(--black);
            overflow-x: hidden;
            position: relative;
        }
        /* Sci-Fi Animated Elements */
        .sci-fi-element {
            position: fixed;
            z-index: -1;
            opacity: 0.2;
            transform-style: preserve-3d;
        }
        /* Holographic Cubes */
        .hologram-cube {
            animation: rotate3d 30s infinite linear;
        }
        .hologram-face {
            position: absolute;
            border: 2px solid var(--cyan);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 15px;
            font-weight: bold;
            color: var(--cyan);
            background: rgba(0, 255, 255, 0.1);
            box-shadow: 0 0 20px var(--cyan);
        }
        .cube-1 {
            top: 5%;
            left: 5%;
            width: 60px;
            height: 60px;
        }
        .cube-1 .hologram-face:nth-child(1) { transform: translateZ(30px); }
        .cube-1 .hologram-face:nth-child(2) { transform: rotateY(180deg) translateZ(30px); background: var(--cyan); color: var(--black); }
        .cube-1 .hologram-face:nth-child(3) { transform: rotateY(90deg) translateZ(30px); }
        .cube-1 .hologram-face:nth-child(4) { transform: rotateY(-90deg) translateZ(30px); background: var(--cyan); color: var(--black); }
        .cube-1 .hologram-face:nth-child(5) { transform: rotateX(90deg) translateZ(30px); }
        .cube-1 .hologram-face:nth-child(6) { transform: rotateX(-90deg) translateZ(30px); background: var(--cyan); color: var(--black); }
        .cube-2 {
            top: 85%;
            right: 15%;
            width: 80px;
            height: 80px;
            animation-delay: 5s;
            animation-duration: 35s;
        }
        .cube-2 .hologram-face {
            border: 2px solid var(--magenta);
            color: var(--magenta);
            background: rgba(255, 0, 255, 0.1);
            box-shadow: 0 0 20px var(--magenta);
        }
        .cube-2 .hologram-face:nth-child(2),
        .cube-2 .hologram-face:nth-child(4),
        .cube-2 .hologram-face:nth-child(6) {
            background: var(--magenta);
            color: var(--white);
        }
        .cube-2 .hologram-face:nth-child(1) { transform: translateZ(40px); }
        .cube-2 .hologram-face:nth-child(2) { transform: rotateY(180deg) translateZ(40px); }
        .cube-2 .hologram-face:nth-child(3) { transform: rotateY(90deg) translateZ(40px); }
        .cube-2 .hologram-face:nth-child(4) { transform: rotateY(-90deg) translateZ(40px); }
        .cube-2 .hologram-face:nth-child(5) { transform: rotateX(90deg) translateZ(40px); }
        .cube-2 .hologram-face:nth-child(6) { transform: rotateX(-90deg) translateZ(40px); }
        /* Energy Orbs */
        .energy-orb {
            position: absolute;
            border-radius: 50%;
            animation: float 25s infinite ease-in-out;
            box-shadow: 0 0 30px;
        }
        .orb-1 {
            top: 20%;
            left: 80%;
            width: 90px;
            height: 90px;
            background: radial-gradient(circle, var(--cyan), transparent 70%);
            box-shadow: 0 0 50px var(--cyan);
            animation-delay: 2s;
        }
        .orb-2 {
            bottom: 30%;
            right: 25%;
            width: 120px;
            height: 120px;
            background: radial-gradient(circle, var(--magenta), transparent 70%);
            box-shadow: 0 0 50px var(--magenta);
            animation-delay: 7s;
            animation-duration: 30s;
        }
        .orb-3 {
            top: 60%;
            left: 10%;
            width: 70px;
            height: 70px;
            background: radial-gradient(circle, var(--gold), transparent 70%);
            box-shadow: 0 0 50px var(--gold);
            animation-delay: 4s;
        }
        /* Laser Grid */
        .laser-grid {
            position: absolute;
            width: 100%;
            height: 100%;
            background: 
                linear-gradient(90deg, transparent 49%, rgba(0, 255, 255, 0.1) 50%, transparent 51%),
                linear-gradient(transparent 49%, rgba(255, 0, 255, 0.1) 50%, transparent 51%);
            background-size: 50px 50px;
            animation: pulse 3s infinite;
            opacity: 0.1;
        }
        /* Holographic Pyramids */
        .hologram-pyramid {
            position: absolute;
            width: 0;
            height: 0;
            transform-style: preserve-3d;
            animation: float 30s infinite ease-in-out;
        }
        .pyramid-face {
            position: absolute;
            border-left: 45px solid transparent;
            border-right: 45px solid transparent;
            border-bottom: 80px solid;
            transform-origin: bottom center;
        }
        .pyramid-1 {
            top: 40%;
            left: 15%;
            animation-delay: 3s;
        }
        .pyramid-1 .pyramid-face {
            border-bottom-color: var(--cyan);
            box-shadow: 0 0 20px var(--cyan);
        }
        .pyramid-2 {
            bottom: 15%;
            right: 10%;
            animation-delay: 9s;
            animation-duration: 35s;
        }
        .pyramid-2 .pyramid-face {
            border-left: 55px solid transparent;
            border-right: 55px solid transparent;
            border-bottom: 100px solid var(--magenta);
            box-shadow: 0 0 20px var(--magenta);
        }
        /* Energy Rings */
        .energy-ring {
            position: absolute;
            border-radius: 50%;
            border: 3px solid;
            animation: spin 20s infinite linear;
        }
        .ring-1 {
            top: 10%;
            right: 20%;
            width: 100px;
            height: 100px;
            border-color: var(--cyan);
            box-shadow: 0 0 20px var(--cyan);
            animation-delay: 1s;
        }
        .ring-2 {
            bottom: 20%;
            left: 25%;
            width: 150px;
            height: 150px;
            border-color: var(--magenta);
            box-shadow: 0 0 20px var(--magenta);
            animation-delay: 6s;
            animation-duration: 25s;
        }
        /* Floating Hexagons */
        .floating-hexagon {
            position: absolute;
            width: 80px;
            height: 46px;
            background: transparent;
            border: 2px solid var(--gold);
            position: relative;
            transform-style: preserve-3d;
            animation: float 28s infinite ease-in-out;
            box-shadow: 0 0 20px var(--gold);
        }
        .floating-hexagon:before {
            content: "";
            position: absolute;
            top: -23px;
            left: -2px;
            width: 80px;
            height: 0;
            border-left: 40px solid transparent;
            border-right: 40px solid transparent;
            border-bottom: 23px solid transparent;
            border-bottom-color: inherit;
        }
        .floating-hexagon:after {
            content: "";
            position: absolute;
            bottom: -23px;
            left: -2px;
            width: 80px;
            height: 0;
            border-left: 40px solid transparent;
            border-right: 40px solid transparent;
            border-top: 23px solid transparent;
            border-top-color: inherit;
        }
        .hexagon-1 {
            top: 75%;
            left: 70%;
            animation-delay: 5s;
        }
        .hexagon-2 {
            top: 5%;
            right: 45%;
            width: 100px;
            height: 58px;
            animation-delay: 11s;
            animation-duration: 32s;
        }
        .hexagon-2:before {
            top: -29px;
            left: -2px;
            border-left: 50px solid transparent;
            border-right: 50px solid transparent;
            border-bottom: 29px solid transparent;
        }
        .hexagon-2:after {
            bottom: -29px;
            left: -2px;
            border-left: 50px solid transparent;
            border-right: 50px solid transparent;
            border-top: 29px solid transparent;
        }
        .hexagon-2 {
            border-color: var(--light-blue);
            box-shadow: 0 0 20px var(--light-blue);
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        /* Header Styles */
        header {
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1000;
            padding: 20px 0;
            background: rgba(255, 255, 255, 0.95);
            box-shadow: 0 2px 20px rgba(0,0,0,0.1);
            transition: all 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            backdrop-filter: blur(10px);
        }
        header.scrolled {
            padding: 10px 0;
            background: rgba(255, 255, 255, 0.98);
        }
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .logo {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-right:-10%;
        }
        .logo-img {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--white);
            font-size: 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 139, 0.3);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            transform-style: preserve-3d;
            perspective: 1000px;
        }
        .logo-img:hover {
            transform: scale(1.1) rotate(15deg);
        }
        .logo-img img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 50%;
            transition: transform 0.5s ease;
        }
        .logo-img:hover img {
            transform: scale(1.1) rotate(10deg);
        }
        .logo-text h1 {
            font-size: 28px;
            color: var(--dark-blue);
            margin-bottom: 5px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
        }
        .logo-text p {
            font-size: 14px;
            color: var(--dark-gray);
        }
        nav ul {
            display: flex;
            list-style: none;
            gap: 30px;
        }
        nav a {
            color: var(--black);
            text-decoration: none;
            font-weight: 600;
            position: relative;
            padding: 5px 0;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        nav a:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 0;
            height: 3px;
            background: var(--dark-blue);
            transition: all 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55);
        }
        nav a:hover:after {
            width: 100%;
        }
        nav a:hover {
            color: var(--dark-blue);
            transform: translateY(-2px);
        }
        /* Hero Section */
        .hero {
            height: 100vh;
            display: flex;
            align-items: center;
            position: relative;
            overflow: hidden;
            padding-top: 80px;
            background: linear-gradient(135deg, var(--light-gray) 0%, var(--white) 100%);
        }
        .hero-content {
            position: relative;
            z-index: 2;
            max-width: 600px;
            animation: fadeInUp 1s ease-out;
        }
        .hero h2 {
            font-size: 3.5rem;
            margin-bottom: 20px;
            line-height: 1.2;
            color: var(--black);
            text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
        }
        .hero h2 span {
            color: var(--dark-blue);
            position: relative;
        }
        .hero h2 span:after {
            content: '';
            position: absolute;
            bottom: -5px;
            left: 0;
            width: 100%;
            height: 3px;
            background: var(--red);
            transform: scaleX(0);
            transform-origin: right;
            transition: transform 0.5s ease;
        }
        .hero h2 span:hover:after {
            transform: scaleX(1);
            transform-origin: left;
        }
        .hero p {
            font-size: 1.2rem;
            margin-bottom: 30px;
            color: var(--dark-gray);
            line-height: 1.6;
            animation: fadeInUp 1s ease-out 0.3s both;
        }
        .btn {
            display: inline-block;
            padding: 15px 30px;
            background: var(--dark-blue);
            color: var(--white);
            border: none;
            border-radius: 30px;
            font-weight: bold;
            text-decoration: none;
            cursor: pointer;
            transition: all 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            box-shadow: 0 10px 25px rgba(0, 0, 139, 0.3);
            position: relative;
            overflow: hidden;
            animation: fadeInUp 1s ease-out 0.6s both;
            transform-style: preserve-3d;
            perspective: 1000px;
        }
        .btn:before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: 0.5s;
        }
        .btn:hover:before {
            left: 100%;
        }
        .btn:hover {
            background: var(--red);
            transform: translateY(-5px) scale(1.05) rotateX(5deg);
            box-shadow: 0 15px 30px rgba(220, 20, 60, 0.4);
        }
        .btn-red {
            background: var(--red);
        }
        .btn-red:hover {
            background: var(--dark-blue);
        }
        .hero-3d {
            position: absolute;
            right: 50px;
            top: 50%;
            transform: translateY(-50%);
            width: 400px;
            height: 400px;
            perspective: 1000px;
            animation: float 8s ease-in-out infinite;
        }
        .hero-cube {
            width: 200px;
            height: 200px;
            position: relative;
            transform-style: preserve-3d;
            animation: rotate3d 15s infinite linear;
            margin: 0 auto;
        }
        .hero-cube-face {
            position: absolute;
            width: 200px;
            height: 200px;
            background: rgba(0, 0, 139, 0.8);
            border: 3px solid var(--white);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 30px;
            font-weight: bold;
            color: var(--white);
        }
        .hero-cube-face:nth-child(1) { transform: translateZ(100px); }
        .hero-cube-face:nth-child(2) { transform: rotateY(180deg) translateZ(100px); background: var(--red); }
        .hero-cube-face:nth-child(3) { transform: rotateY(90deg) translateZ(100px); background: var(--light-blue); }
        .hero-cube-face:nth-child(4) { transform: rotateY(-90deg) translateZ(100px); background: var(--purple); }
        .hero-cube-face:nth-child(5) { transform: rotateX(90deg) translateZ(100px); background: var(--green); }
        .hero-cube-face:nth-child(6) { transform: rotateX(-90deg) translateZ(100px); background: var(--gold); color: var(--black); }
        /* Sections */
        section {
            padding: 120px 0;
            position: relative;
        }
        .section-title {
            text-align: center;
            margin-bottom: 80px;
            position: relative;
        }
        .section-title h2 {
            font-size: 3rem;
            color: var(--black);
            position: relative;
            z-index: 2;
            display: inline-block;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        .section-title:after {
            content: '';
            position: absolute;
            bottom: -20px;
            left: 50%;
            transform: translateX(-50%);
            width: 150px;
            height: 5px;
            background: var(--dark-blue);
            border-radius: 3px;
            box-shadow: 0 0 20px var(--dark-blue);
        }
        .section-title:before {
            content: '';
            position: absolute;
            bottom: -15px;
            left: 50%;
            transform: translateX(-50%);
            width: 20px;
            height: 20px;
            background: var(--red);
            border-radius: 50%;
            animation: pulse 2s infinite;
        }
        /* About Section - Fixed (No 3D Movement) */
        #about {
            position: relative;
            background: var(--light-gray);
        }
        .about-content {
            display: flex;
            align-items: center;
            gap: 50px;
        }
        .about-text {
            flex: 1;
        }
        .about-text h3 {
            font-size: 2.5rem;
            margin-bottom: 30px;
            color: var(--dark-blue);
            position: relative;
            padding-bottom: 15px;
        }
        .about-text h3:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 80px;
            height: 4px;
            background: var(--red);
        }
        .about-text p {
            margin-bottom: 25px;
            line-height: 1.8;
            color: var(--dark-gray);
            font-size: 1.1rem;
        }
        .about-image {
            flex: 1;
        }
        .director-card {
            background: var(--white);
            border-radius: 20px;
            padding: 40px;
            text-align: center;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            border: 2px solid var(--silver);
            transform-style: preserve-3d;
            perspective: 1000px;
            transition: transform 0.5s ease;
        }
        .director-card:hover {
            transform: translateY(-10px) rotateX(5deg);
        }
        .director-card:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: var(--dark-blue);
            transform: scaleX(1);
            transform-origin: left;
        }
        .director-img {
            width: 180px;
            height: 180px;
            border-radius: 50%;
            margin: 0 auto 30px;
            background: var(--dark-blue);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 70px;
            color: var(--white);
            box-shadow: 0 15px 30px rgba(0, 0, 139, 0.3);
            border: 5px solid var(--white);
            position: relative;
            overflow: hidden;
            transform-style: preserve-3d;
            perspective: 1000px;
            transition: transform 0.5s ease;
        }
        .director-card:hover .director-img {
            transform: scale(1.1) rotateY(10deg);
        }
        .director-card h4 {
            font-size: 1.8rem;
            margin-bottom: 15px;
            color: var(--dark-blue);
        }
        .director-card p {
            font-style: italic;
            color: var(--dark-gray);
            margin-bottom: 20px;
            line-height: 1.6;
        }
        .quote {
            position: relative;
            padding: 20px;
            background: var(--light-gray);
            border-radius: 15px;
            margin-top: 20px;
            border-left: 5px solid var(--red);
        }
        .quote:before {
            content: '"';
            position: absolute;
            top: -20px;
            left: 10px;
            font-size: 4rem;
            color: var(--dark-blue);
            opacity: 0.3;
            font-family: serif;
        }
        /* Diplomas Section */
        .diplomas-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(380px, 1fr));
            gap: 40px;
        }
        .diploma-card {
            background: var(--white);
            border-radius: 20px;
            padding: 35px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            border: 2px solid var(--silver);
            transition: all 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            position: relative;
            overflow: hidden;
            transform-style: preserve-3d;
            transform: translateZ(0);
        }
        .diploma-card:hover {
            transform: translateY(-15px) scale(1.02) rotateX(5deg);
            box-shadow: 0 25px 50px rgba(0,0,0,0.15);
            border-color: var(--dark-blue);
        }
        .diploma-card:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: var(--dark-blue);
            transform: scaleX(0);
            transform-origin: left;
            transition: transform 0.5s ease;
        }
        .diploma-card:hover:before {
            transform: scaleX(1);
        }
        .diploma-header {
            display: flex;
            align-items: center;
            gap: 25px;
            margin-bottom: 25px;
        }
        .diploma-icon {
            width: 70px;
            height: 70px;
            background: var(--dark-blue);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 28px;
            color: var(--white);
            box-shadow: 0 10px 20px rgba(0, 0, 139, 0.3);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            transform-style: preserve-3d;
            perspective: 1000px;
        }
        .diploma-card:hover .diploma-icon {
            transform: rotate(15deg) scale(1.1);
            background: var(--red);
        }
        .diploma-card h3 {
            font-size: 1.8rem;
            color: var(--dark-blue);
            margin-bottom: 10px;
        }
        .diploma-card .description {
            color: var(--dark-gray);
            margin-bottom: 25px;
            line-height: 1.6;
        }
        .courses-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin-top: 20px;
        }
        .course-item {
            background: var(--light-gray);
            padding: 15px;
            border-radius: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s ease;
            border: 1px solid var(--silver);
            position: relative;
            overflow: hidden;
            transform-style: preserve-3d;
            perspective: 1000px;
        }
        .course-item:hover {
            background: var(--dark-blue);
            transform: translateX(8px) rotateY(5deg);
        }
        .course-item:hover .course-name {
            color: var(--white);
        }
        .course-item:hover .course-price {
            background: var(--red);
        }
        .course-name {
            color: var(--black);
            font-weight: 600;
            font-size: 0.95rem;
        }
        .course-price {
            color: var(--white);
            font-weight: bold;
            background: var(--dark-blue);
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 0.9rem;
            transition: all 0.3s ease;
        }
        /* Books Section - Interactive 3D Books */
        .books-section {
            background: linear-gradient(135deg, var(--light-gray) 0%, var(--white) 100%);
            position: relative;
            overflow: hidden;
            padding: 100px 0;
        }
        .library-header {
            text-align: center;
            margin-bottom: 60px;
        }
        .library-header h2 {
            font-size: 3rem;
            color: var(--dark-blue);
            margin-bottom: 20px;
            text-transform: uppercase;
            letter-spacing: 2px;
            position: relative;
            display: inline-block;
        }
        .library-header h2:after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 100px;
            height: 4px;
            background: var(--red);
            border-radius: 2px;
        }
        .library-header p {
            font-size: 1.3rem;
            color: var(--dark-gray);
            max-width: 800px;
            margin: 0 auto 30px;
            line-height: 1.6;
        }
        /* Interactive 3D Books Gallery */
        .books-gallery {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 30px;
            margin: 50px 0;
        }
        .book-3d-container {
            perspective: 1000px;
            height: 280px;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .book-3d-item {
            width: 130px;
            height: 190px;
            position: relative;
            transform-style: preserve-3d;
            transform: rotateY(0deg);
            transition: transform 0.8s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            cursor: pointer;
        }
        .book-3d-item:hover {
            transform: rotateY(25deg) translateZ(30px);
        }
        .book-front-cover {
            position: absolute;
            width: 100%;
            height: 100%;
            background: linear-gradient(45deg, var(--dark-blue), var(--light-blue));
            border: 3px solid rgba(255,255,255,0.3);
            border-radius: 5px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 12px;
            font-weight: bold;
            text-align: center;
            padding: 8px;
            transform: translateZ(15px);
            box-shadow: 8px 8px 25px rgba(0,0,0,0.3);
        }
        .book-back-cover {
            position: absolute;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.2);
            border-radius: 5px;
            transform: translateZ(-15px) rotateY(180deg);
        }
        .book-spine {
            position: absolute;
            width: 30px;
            height: 100%;
            background: rgba(0,0,0,0.3);
            transform: rotateY(90deg) translateZ(65px);
            left: 50%;
            margin-left: -15px;
            border-radius: 3px;
        }
        .book-top-edge {
            position: absolute;
            width: 100%;
            height: 30px;
            background: rgba(0,0,0,0.25);
            transform: rotateX(90deg) translateZ(175px);
            top: 50%;
            margin-top: -15px;
            border-radius: 3px;
        }
        /* Different book styles */
        .book-3d-item:nth-child(2) .book-front-cover {
            background: linear-gradient(45deg, var(--red), #FF6347);
        }
        .book-3d-item:nth-child(3) .book-front-cover {
            background: linear-gradient(45deg, var(--green), #32CD32);
        }
        .book-3d-item:nth-child(4) .book-front-cover {
            background: linear-gradient(45deg, var(--purple), #9370DB);
        }
        .book-3d-item:nth-child(5) .book-front-cover {
            background: linear-gradient(45deg, var(--orange), #FFA500);
        }
        .book-3d-item:nth-child(6) .book-front-cover {
            background: linear-gradient(45deg, #4B0082, #8A2BE2);
        }
        .book-3d-item:nth-child(7) .book-front-cover {
            background: linear-gradient(45deg, #2F4F4F, #556B2F);
        }
        .book-3d-item:nth-child(8) .book-front-cover {
            background: linear-gradient(45deg, #8B0000, #A52A2A);
        }
        /* Book Modal */
        .book-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.8);
            z-index: 2000;
            justify-content: center;
            align-items: center;
            animation: fadeIn 0.5s ease;
        }
        .book-modal-content {
            background: var(--white);
            border-radius: 20px;
            padding: 40px;
            width: 90%;
            max-width: 800px;
            max-height: 90vh;
            overflow-y: auto;
            position: relative;
            transform: scale(0.8);
            animation: modalAppear 0.5s forwards;
            box-shadow: 0 0 50px rgba(0, 255, 255, 0.5);
        }
        @keyframes modalAppear {
            to {
                transform: scale(1);
            }
        }
        .close-modal {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 30px;
            cursor: pointer;
            color: var(--dark-gray);
            transition: color 0.3s ease;
        }
        .close-modal:hover {
            color: var(--red);
        }
        .modal-book-cover {
            width: 200px;
            height: 300px;
            margin: 0 auto 30px;
            background: linear-gradient(45deg, var(--dark-blue), var(--light-blue));
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 60px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.3);
        }
        .modal-book-info h3 {
            font-size: 2rem;
            color: var(--dark-blue);
            margin-bottom: 15px;
            text-align: center;
        }
        .modal-book-author {
            text-align: center;
            font-size: 1.2rem;
            color: var(--dark-gray);
            margin-bottom: 20px;
            font-style: italic;
        }
        .modal-book-category {
            display: inline-block;
            background: var(--dark-blue);
            color: var(--white);
            padding: 8px 20px;
            border-radius: 25px;
            font-size: 1rem;
            margin-bottom: 20px;
        }
        .modal-book-description {
            font-size: 1.1rem;
            line-height: 1.8;
            color: var(--dark-gray);
            margin-bottom: 30px;
        }
        .modal-book-rating {
            text-align: center;
            color: var(--gold);
            font-size: 1.5rem;
            margin-bottom: 30px;
        }
        /* Contact Section */
        .contact-container {
            display: flex;
            gap: 60px;
            animation: fadeIn 1s ease-out;
        }
        .contact-info {
            flex: 1;
        }
        .contact-info h3 {
            font-size: 2.2rem;
            margin-bottom: 30px;
            color: var(--dark-blue);
            position: relative;
            padding-bottom: 15px;
        }
        .contact-info h3:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100px;
            height: 4px;
            background: var(--red);
        }
        .contact-info p {
            margin-bottom: 40px;
            line-height: 1.8;
            color: var(--dark-gray);
            font-size: 1.1rem;
        }
        .contact-details {
            margin-bottom: 40px;
        }
        .contact-item {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 30px;
            padding: 20px;
            background: var(--light-gray);
            border-radius: 15px;
            transition: all 0.3s ease;
            border: 1px solid var(--silver);
            position: relative;
            overflow: hidden;
            transform-style: preserve-3d;
            perspective: 1000px;
        }
        .contact-item:hover {
            transform: translateX(10px) rotateY(5deg);
            border-color: var(--dark-blue);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
        .contact-icon {
            width: 60px;
            height: 60px;
            background: var(--dark-blue);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            color: var(--white);
            flex-shrink: 0;
            box-shadow: 0 8px 15px rgba(0, 0, 139, 0.3);
            transform-style: preserve-3d;
            perspective: 1000px;
            transition: transform 0.3s ease;
        }
        .contact-item:hover .contact-icon {
            transform: scale(1.1) rotate(10deg);
        }
        .contact-text h4 {
            font-size: 1.3rem;
            margin-bottom: 8px;
            color: var(--black);
        }
        .contact-text p {
            margin: 0;
            color: var(--dark-gray);
            font-size: 1rem;
        }
        .contact-form {
            flex: 1;
            background: var(--white);
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            border: 2px solid var(--silver);
            transition: all 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            position: relative;
            overflow: hidden;
            transform-style: preserve-3d;
            perspective: 1000px;
        }
        .contact-form:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: var(--dark-blue);
            transform: scaleX(0);
            transform-origin: left;
            transition: transform 0.5s ease;
        }
        .contact-form:hover:before {
            transform: scaleX(1);
        }
        .contact-form:hover {
            border-color: var(--dark-blue);
            transform: translateY(-5px) rotateX(3deg);
        }
        .form-group {
            margin-bottom: 25px;
        }
        .form-group label {
            display: block;
            margin-bottom: 10px;
            color: var(--black);
            font-weight: 600;
            font-size: 1.1rem;
        }
        .form-group input,
        .form-group textarea {
            width: 100%;
            padding: 18px;
            border: 2px solid var(--silver);
            border-radius: 15px;
            color: var(--black);
            font-size: 1rem;
            transition: all 0.3s ease;
            background: var(--light-gray);
        }
        .form-group input:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: var(--dark-blue);
            box-shadow: 0 0 0 4px rgba(0, 0, 139, 0.1);
            background: var(--white);
        }
        .form-group textarea {
            height: 180px;
            resize: vertical;
        }
        /* Footer */
        footer {
            background: var(--black);
            color: var(--white);
            padding: 70px 0 30px;
            position: relative;
        }
        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 40px;
            margin-bottom: 50px;
        }
        .footer-column h3 {
            font-size: 1.8rem;
            margin-bottom: 25px;
            color: var(--white);
            position: relative;
            padding-bottom: 15px;
        }
        .footer-column h3:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 60px;
            height: 4px;
            background: var(--dark-blue);
            border-radius: 2px;
        }
        .footer-column p {
            color: var(--silver);
            line-height: 1.8;
            margin-bottom: 25px;
            font-size: 1rem;
        }
        .social-links {
            display: flex;
            gap: 18px;
            margin-top: 20px;
        }
        .social-link {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: var(--dark-gray);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--white);
            text-decoration: none;
            transition: all 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            font-size: 1.2rem;
            transform-style: preserve-3d;
            perspective: 1000px;
        }
        .social-link:hover {
            background: var(--dark-blue);
            transform: translateY(-8px) rotate(15deg);
            box-shadow: 0 10px 20px rgba(0,0,0,0.3);
        }
        .footer-links {
            list-style: none;
        }
        .footer-links li {
            margin-bottom: 15px;
        }
        .footer-links a {
            color: var(--silver);
            text-decoration: none;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 1.1rem;
        }
        .footer-links a:hover {
            color: var(--white);
            transform: translateX(8px);
        }
        .footer-links i {
            color: var(--dark-blue);
            width: 20px;
        }
        .copyright {
            text-align: center;
            padding-top: 30px;
            border-top: 1px solid var(--dark-gray);
            color: var(--silver);
            font-size: 1rem;
        }
        /* Animations */
        @keyframes rotate3d {
            0% { transform: rotateX(0) rotateY(0) rotateZ(0); }
            100% { transform: rotateX(360deg) rotateY(360deg) rotateZ(360deg); }
        }
        @keyframes float {
            0% { transform: translateY(0px) translateX(0px) rotate(0deg); }
            25% { transform: translateY(-50px) translateX(40px) rotate(90deg); }
            50% { transform: translateY(-30px) translateX(80px) rotate(180deg); }
            75% { transform: translateY(-70px) translateX(40px) rotate(270deg); }
            100% { transform: translateY(0px) translateX(0px) rotate(360deg); }
        }
        @keyframes pulse {
            0% { opacity: 0.1; }
            50% { opacity: 0.3; }
            100% { opacity: 0.1; }
        }
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(50px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        @keyframes slideInLeft {
            from {
                opacity: 0;
                transform: translateX(-100px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(100px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        @keyframes bounce {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-20px); }
        }
        @keyframes glow {
            0% { box-shadow: 0 0 5px var(--cyan); }
            50% { box-shadow: 0 0 20px var(--cyan); }
            100% { box-shadow: 0 0 5px var(--cyan); }
        }
        /* Responsive */
        @media (max-width: 992px) {
            .hero-content {
                max-width: 100%;
                text-align: center;
                padding: 0 20px;
            }
            .hero-3d {
                display: none;
            }
            .about-content {
                flex-direction: column;
            }
            .contact-container {
                flex-direction: column;
            }
            .diplomas-grid {
                grid-template-columns: 1fr;
            }
            .books-gallery {
                grid-template-columns: repeat(auto-fit, minmax(140px, 1fr));
                gap: 20px;
            }
            .book-3d-container {
                height: 240px;
            }
            .book-3d-item {
                width: 100px;
                height: 150px;
            }
            .book-front-cover {
                font-size: 10px;
            }
            .book-spine {
                width: 25px;
                transform: rotateY(90deg) translateZ(50px);
                margin-left: -12.5px;
            }
            .book-top-edge {
                height: 25px;
                transform: rotateX(90deg) translateZ(137.5px);
                margin-top: -12.5px;
            }
        }
        @media (max-width: 768px) {
            nav ul {
                gap: 15px;
                flex-wrap: wrap;
                justify-content: center;
            }
            .hero h2 {
                font-size: 2.5rem;
            }
            section {
                padding: 80px 0;
            }
            .section-title h2 {
                font-size: 2.2rem;
            }
            .courses-grid {
                grid-template-columns: 1fr;
            }
            .books-gallery {
                grid-template-columns: repeat(2, 1fr);
            }
        }
        
        .engineer-stamp {
            position: fixed;
            bottom: 20px;
            left: 20px;
            background:  var(--dark-blue);
            color: white;
            padding: 10px 20px;
            border-radius: 30px;
            font-weight: bold;
            font-size: 1rem;
            box-shadow: var(--box-shadow);
            z-index: 1000;
        }
    </style>
</head>
<body>
    <!-- Sci-Fi Animated Elements -->
    <div class="sci-fi-element hologram-cube cube-1">
        <div class="hologram-face"></div>
        <div class="hologram-face"></div>
        <div class="hologram-face"></div>
        <div class="hologram-face"></div>
        <div class="hologram-face"></div>
        <div class="hologram-face"></div>
    </div>
    <div class="sci-fi-element hologram-cube cube-2">
        <div class="hologram-face"></div>
        <div class="hologram-face"></div>
        <div class="hologram-face"></div>
        <div class="hologram-face"></div>
        <div class="hologram-face"></div>
        <div class="hologram-face"></div>
    </div>
    <div class="sci-fi-element energy-orb orb-1"></div>
    <div class="sci-fi-element energy-orb orb-2"></div>
    <div class="sci-fi-element energy-orb orb-3"></div>
    <div class="sci-fi-element hologram-pyramid pyramid-1">
        <div class="pyramid-face"></div>
    </div>
    <div class="sci-fi-element hologram-pyramid pyramid-2">
        <div class="pyramid-face"></div>
    </div>
    <div class="sci-fi-element energy-ring ring-1"></div>
    <div class="sci-fi-element energy-ring ring-2"></div>
    <div class="sci-fi-element floating-hexagon hexagon-1"></div>
    <div class="sci-fi-element floating-hexagon hexagon-2"></div>
    <div class="sci-fi-element laser-grid"></div>
    <!-- Header -->
    <header id="header">
        <div class="container header-content">
            <div class="logo">
                <div class="logo-img">
                    <img src="IMG-20250720-WA0012.jpg" alt="شعار معهد فورلايف">
                </div>
                <div class="logo-text">
                    <h1>معهد فورلايف</h1>
                    <p>التعليم المستقبلي</p>
                </div>
            </div>
            <nav>
                <ul>
                    <li><a href="#home"><i class="fas fa-home"></i> الرئيسية</a></li>
                    <li><a href="#about"><i class="fas fa-info-circle"></i> عن المعهد</a></li>
                    <li><a href="#diplomas"><i class="fas fa-graduation-cap"></i> الدبلومات</a></li>
                    <li><a href="#books"><i class="fas fa-book"></i> المكتبة</a></li>
                    <li><a href="#contact"><i class="fas fa-envelope"></i> تواصل معنا</a></li>
                </ul>
            </nav>
        </div>
    </header>
    <!-- Hero Section -->
    <section class="hero" id="home">
        <div class="container">
            <div class="hero-content">
                <h2>مستقبل التعليم <span>في عالم متقدم</span></h2>
                <p>معهد فورلايف يقدم أفضل الدبلومات والدورات في مجالات متعددة باستخدام أحدث الأساليب التعليمية والمحتوى التعليمي المتقدم</p>
                <a href="#diplomas" class="btn"><i class="fas fa-graduation-cap"></i> استكشف الدبلومات</a>
                <a href="#books" class="btn btn-red"><i class="fas fa-book"></i> تصفح المكتبة</a>
            </div>
             <div class="engineer-stamp">
                E/ Mona Edreis
            </div>
        </div>
        <div class="hero-3d">
            <div class="hero-cube">
                <div class="hero-cube-face"><i class="fas fa-book"></i></div>
                <div class="hero-cube-face"><i class="fas fa-laptop"></i></div>
                <div class="hero-cube-face"><i class="fas fa-stethoscope"></i></div>
                <div class="hero-cube-face"><i class="fas fa-paint-brush"></i></div>
                <div class="hero-cube-face"><i class="fas fa-code"></i></div>
                <div class="hero-cube-face"><i class="fas fa-first-aid"></i></div>
            </div>
        </div>
    </section>
    <!-- About Section - Fixed (No 3D Movement) -->
    <section id="about">
        <div class="container">
            <div class="section-title">
                <h2>عن معهد فورلايف</h2>
            </div>
            <div class="about-content">
                <div class="about-text">
                    <h3>الريادة في التعليم الحديث</h3>
                    <p>معهد فورلايف هو مؤسسة تعليمية رائدة تقدم دبلومات متخصصة في مجالات متعددة باستخدام أحدث الأساليب التعليمية والتقنيات الحديثة. نؤمن بأن التعليم هو مفتاح المستقبل، ولذلك نسعى جاهدين لتقديم أفضل الدورات بأحدث الأساليب التعليمية.</p>
                    <p>يتميز معهدنا بفريق تدريبي متميز من الخبراء في مجالاتهم، وبيئة تعليمية متطورة تدعم التعلم التفاعلي والتطبيقي.</p>
                    <a href="#contact" class="btn"><i class="fas fa-envelope"></i> تواصل معنا</a>
                </div>
                <div class="about-image">
                    <div class="director-card">
                        <div class="director-img">
                            <i class="fas fa-user-tie"></i>
                        </div>
                        <h4>المهندس شاكر الرضواني</h4>
                        <p>مدير المعهد</p>
                        <div class="quote">
                            "التعليم ليس مجرد انتقال للمعلومات، بل هو زراعة البذور التي تنمو في عقول الشباب وتنتج مستقبل مشرق مليء بالإنجازات والإبداع."
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Diplomas Section -->
    <section id="diplomas">
        <div class="container">
            <div class="section-title">
                <h2>الدبلومات والدورات</h2>
            </div>
            <div class="diplomas-grid">
                <?php
                $diplomas = $conn->query("SELECT * FROM diplomas");
                while ($diploma = $diplomas->fetch_assoc()):
                ?>
                <div class="diploma-card">
                    <div class="diploma-header">
                        <div class="diploma-icon">
                            <i class="fas fa-graduation-cap"></i>
                        </div>
                        <div>
                            <h3><?= htmlspecialchars($diploma['name']) ?></h3>
                            <div class="description"><?= htmlspecialchars($diploma['description']) ?></div>
                        </div>
                    </div>
                    <div class="courses-grid">
                        <?php
                        $courses = $conn->query("SELECT * FROM courses WHERE diploma_id = " . $diploma['id'] . " LIMIT 6");
                        while ($course = $courses->fetch_assoc()):
                        ?>
                        <div class="course-item">
                            <span class="course-name"><?= htmlspecialchars($course['name']) ?></span>
                            <span class="course-price"><?= $course['price'] ?></span>
                        </div>
                        <?php endwhile; ?>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
    </section>
    <!-- Books Section - Interactive 3D Books -->
    <section id="books" class="books-section">
        <div class="container">
            <div class="library-header">
                <h2>مكتبة المعهد الإلكترونية</h2>
                <p>اضغط على أي كتاب لعرض تفاصيله وصورته</p>
            </div>
            <!-- Interactive 3D Books Gallery -->
            <div class="books-gallery">
                <?php
                $books = $conn->query("SELECT * FROM books LIMIT 12");
                $bookIndex = 0;
                while ($book = $books->fetch_assoc()):
                    $bookIndex++;
                ?>
                <div class="book-3d-container">
                    <div class="book-3d-item" onclick="openBookModal(<?= $book['id'] ?>)">
                        <div class="book-front-cover">
                            <i class="fas fa-book" style="font-size: 30px; margin-bottom: 10px;"></i>
                            <span><?= htmlspecialchars(substr($book['title'], 0, 30)) ?><?= strlen($book['title']) > 30 ? '...' : '' ?></span>
                        </div>
                        <div class="book-back-cover"></div>
                        <div class="book-spine"></div>
                        <div class="book-top-edge"></div>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
    </section>
    <!-- Book Modal -->
    <div id="bookModal" class="book-modal">
        <div class="book-modal-content">
            <span class="close-modal" onclick="closeBookModal()">&times;</span>
            <div class="modal-book-cover" id="modalBookCover">
                <i class="fas fa-book"></i>
            </div>
            <div class="modal-book-info">
                <h3 id="modalBookTitle">عنوان الكتاب</h3>
                <div class="modal-book-author" id="modalBookAuthor">بقلم: المؤلف</div>
                <div class="modal-book-category" id="modalBookCategory">الفئة</div>
                <div class="modal-book-description" id="modalBookDescription">
                    وصف الكتاب يظهر هنا...
                </div>
                <div class="modal-book-rating" id="modalBookRating">
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star-half-alt"></i>
                    (4.5)
                </div>
            </div>
        </div>
    </div>
    <!-- Contact Section -->
    <section id="contact">
        <div class="container">
            <div class="section-title">
                <h2>تواصل معنا</h2>
            </div>
            <div class="contact-container">
                <div class="contact-info">
                    <h3>معلومات الاتصال</h3>
                    <p>نحن هنا للإجابة عن أي استفسارات لديك. لا تتردد في الاتصال بنا أو إرسال رسالة.</p>
                    <div class="contact-details">
                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fas fa-map-marker-alt"></i>
                            </div>
                            <div class="contact-text">
                                <h4>العنوان</h4>
                                <p>مدينة رداع، بجوار عيادة المنتصر لطب الأسنان</p>
                            </div>
                        </div>
                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fas fa-phone"></i>
                            </div>
                            <div class="contact-text">
                                <h4>الهواتف</h4>
                                <p>0777 777 777<br>0733 333 333</p>
                            </div>
                        </div>
                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fas fa-envelope"></i>
                            </div>
                            <div class="contact-text">
                                <h4>البريد الإلكتروني</h4>
                                <p>forlife.institute.radaa@gmail.com</p>
                            </div>
                        </div>
                    </div>
                    <div class="social-links">
                        <a href="#" class="social-link"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>
                <div class="contact-form">
                    <form method="post">
                        <div class="form-group">
                            <label for="name"><i class="fas fa-user"></i> الاسم الكامل</label>
                            <input type="text" id="name" name="name" required>
                        </div>
                        <div class="form-group">
                            <label for="email"><i class="fas fa-envelope"></i> البريد الإلكتروني</label>
                            <input type="email" id="email" name="email" required>
                        </div>
                        <div class="form-group">
                            <label for="message"><i class="fas fa-comment"></i> رسالتك</label>
                            <textarea id="message" name="message" required></textarea>
                        </div>
                        <button type="submit" name="send_message" class="btn"><i class="fas fa-paper-plane"></i> إرسال الرسالة</button>
                    </form>
                </div>
            </div>
        </div>
    </section>
    <!-- Footer -->
    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-column">
                    <h3><i class="fas fa-graduation-cap"></i> معهد فورلايف</h3>
                    <p>معهد تعليمي رائد يقدم دبلومات متخصصة في مجالات متعددة باستخدام أحدث الأساليب التعليمية والتقنيات الحديثة.</p>
                    <div class="social-links">
                        <a href="#" class="social-link"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>
                <div class="footer-column">
                    <h3><i class="fas fa-link"></i> روابط سريعة</h3>
                    <ul class="footer-links">
                        <li><a href="#home"><i class="fas fa-chevron-right"></i> الرئيسية</a></li>
                        <li><a href="#about"><i class="fas fa-chevron-right"></i> عن المعهد</a></li>
                        <li><a href="#diplomas"><i class="fas fa-chevron-right"></i> الدبلومات</a></li>
                        <li><a href="#books"><i class="fas fa-chevron-right"></i> المكتبة</a></li>
                        <li><a href="#contact"><i class="fas fa-chevron-right"></i> تواصل معنا</a></li>
                    </ul>
                </div>
                <div class="footer-column">
                    <h3><i class="fas fa-graduation-cap"></i> الدبلومات</h3>
                    <ul class="footer-links">
                        <li><a href="#"><i class="fas fa-chevron-right"></i> اللغة الإنجليزية</a></li>
                        <li><a href="#"><i class="fas fa-chevron-right"></i> الحاسوب</a></li>
                        <li><a href="#"><i class="fas fa-chevron-right"></i> التمريض</a></li>
                        <li><a href="#"><i class="fas fa-chevron-right"></i> الجرافيك</a></li>
                        <li><a href="#"><i class="fas fa-chevron-right"></i> البرمجة</a></li>
                    </ul>
                </div>
                <div class="footer-column">
                    <h3><i class="fas fa-info-circle"></i> معلومات الاتصال</h3>
                    <ul class="footer-links">
                        <li><a href="#"><i class="fas fa-map-marker-alt"></i> مدينة رداع، بجوار عيادة المنتصر</a></li>
                        <li><a href="#"><i class="fas fa-phone"></i> 0777 777 777</a></li>
                        <li><a href="#"><i class="fas fa-phone"></i> 0733 333 333</a></li>
                        <li><a href="#"><i class="fas fa-envelope"></i> forlife.institute.radaa@gmail.com</a></li>
                    </ul>
                </div>
            </div>
            <div class="copyright">
                <p>&copy; 2025 معهد فورلايف. جميع الحقوق محفوظة.</p>
            </div>
        </div>
    </footer>
    <script>
        // Header scroll effect
        window.addEventListener('scroll', function() {
            const header = document.getElementById('header');
            if (window.scrollY > 100) {
                header.classList.add('scrolled');
            } else {
                header.classList.remove('scrolled');
            }
        });
        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });
        // Animation on scroll
        const observerOptions = {
            root: null,
            rootMargin: '0px',
            threshold: 0.1
        };
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);
        // Apply animations to elements
        document.addEventListener('DOMContentLoaded', function() {
            const animatedElements = document.querySelectorAll('.diploma-card, .director-card, .contact-container, .book-3d-item');
            animatedElements.forEach(element => {
                element.style.opacity = '0';
                element.style.transform = 'translateY(50px)';
                element.style.transition = 'opacity 0.8s ease, transform 0.8s ease';
                observer.observe(element);
            });
        });
        // Add hover effects to all buttons
        document.querySelectorAll('.btn').forEach(button => {
            button.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-3px) scale(1.05) rotateX(5deg)';
            });
            button.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0) scale(1) rotateX(0)';
            });
        });
        // 3D book hover effects
        document.querySelectorAll('.book-3d-item').forEach(book => {
            book.addEventListener('mouseenter', function() {
                this.style.transform = 'rotateY(25deg) translateZ(30px)';
            });
            book.addEventListener('mouseleave', function() {
                this.style.transform = 'rotateY(0deg) translateZ(0px)';
            });
        });
        // Book Modal Functions
        function openBookModal(bookId) {
            // في التطبيق الحقيقي، ستجلب البيانات من قاعدة البيانات
            // هنا نستخدم بيانات تجريبية
            const booksData = [
                {
                    id: 1,
                    title: "الإنجليزية للمبتدئين",
                    author: "د. أحمد محمد",
                    category: "لغات",
                    description: "دورة شاملة للمرحلة المبتدئة في اللغة الإنجليزية. تحتوي على تمارين عملية وشروحات مفصلة.",
                    rating: 4.5
                },
                {
                    id: 2,
                    title: "الحاسوب الأساسي",
                    author: "م. فاطمة علي",
                    category: "تقنية",
                    description: "مبادئ استخدام الحاسوب وأنظمة التشغيل. دليل شامل للمبتدئين.",
                    rating: 4.2
                },
                {
                    id: 3,
                    title: "التمريض العملي",
                    author: "د. سارة أحمد",
                    category: "طب",
                    description: "تطبيقات عملية في التمريض السريري. يحتوي على حالات دراسية وحلول عملية.",
                    rating: 4.8
                },
                {
                    id: 4,
                    title: "الجرافيك الحديث",
                    author: "م. خالد عمر",
                    category: "فن",
                    description: "أحدث تقنيات التصميم الجرافيكي. دليل عملي بأحدث البرامج.",
                    rating: 4.6
                },
                {
                    id: 5,
                    title: "البرمجة بلغة بايثون",
                    author: "د. محمد حسن",
                    category: "تقنية",
                    description: "مقدمة في البرمجة بلغة بايثون للمبتدئين. يحتوي على تمارين ومشاريع.",
                    rating: 4.7
                },
                {
                    id: 6,
                    title: "الإسعافات الأولية",
                    author: "د. علي عبد الله",
                    category: "طب",
                    description: "دليل الإسعافات الأولية في الحالات الطارئة. دليل عملي مصور.",
                    rating: 4.3
                }
            ];
            const book = booksData.find(b => b.id === bookId) || booksData[0];
            document.getElementById('modalBookTitle').textContent = book.title;
            document.getElementById('modalBookAuthor').textContent = 'بقلم: ' + book.author;
            document.getElementById('modalBookCategory').textContent = book.category;
            document.getElementById('modalBookDescription').textContent = book.description;
            // تحديث التقييم
            const ratingElement = document.getElementById('modalBookRating');
            ratingElement.innerHTML = '';
            for (let i = 1; i <= 5; i++) {
                if (i <= Math.floor(book.rating)) {
                    ratingElement.innerHTML += '<i class="fas fa-star"></i>';
                } else if (i - 0.5 <= book.rating) {
                    ratingElement.innerHTML += '<i class="fas fa-star-half-alt"></i>';
                } else {
                    ratingElement.innerHTML += '<i class="far fa-star"></i>';
                }
            }
            ratingElement.innerHTML += ` (${book.rating})`;
            document.getElementById('bookModal').style.display = 'flex';
        }
        function closeBookModal() {
            document.getElementById('bookModal').style.display = 'none';
        }
        // Close modal when clicking outside
        window.addEventListener('click', function(event) {
            const modal = document.getElementById('bookModal');
            if (event.target === modal) {
                closeBookModal();
            }
        });
        // Animate sci-fi elements
        const sciFiElements = document.querySelectorAll('.sci-fi-element');
        sciFiElements.forEach((element, index) => {
            element.style.animationDelay = (index * 0.3) + 's';
        });
    </script>
</body>
</html>
```